//
//  AppDelegate.m
//  TextUpdates
//
//  Created by Markus Möller on 10.05.13.
//  Copyright (c) 2013 Markus Möller. All rights reserved.
//

#import "AppDelegate.h"

#import "ViewController.h"

@implementation AppDelegate

- (BOOL)application:(UIApplication *)application didFinishLaunchingWithOptions:(NSDictionary *)launchOptions {
    self.window = [[UIWindow alloc] initWithFrame:[[UIScreen mainScreen] bounds]];

    NSArray *paths = NSSearchPathForDirectoriesInDomains(NSDocumentDirectory, NSUserDomainMask, YES);
    NSString *documentsDirectory = [[paths objectAtIndex:0] stringByAppendingString:@"/"];

    NSString *bundleRoot = [[[NSBundle mainBundle] bundlePath] stringByAppendingString:@"/"];
    NSFileManager *fileManager = [NSFileManager defaultManager];
    NSArray *dirContents = [fileManager contentsOfDirectoryAtPath:bundleRoot error:nil];
    NSPredicate *predicate = [NSPredicate predicateWithFormat:@"self ENDSWITH '.lproj'"];
    NSArray *allLprojDirs = [dirContents filteredArrayUsingPredicate:predicate];

    NSLog(@"alldirs %@", allLprojDirs);
    [allLprojDirs enumerateObjectsUsingBlock:^(id obj, NSUInteger idx, BOOL *stop) {
        NSError *error;
        NSString *fromPath = [bundleRoot stringByAppendingString:[obj description]];
        NSString *toPath = [documentsDirectory stringByAppendingString:[obj description]];

        // All *.lproj dirs with their strings files are only copied one time:
        // If the dirs in Documents do not exist.
        if (![fileManager fileExistsAtPath:toPath]) {
            NSLog(@"Copying from %@ to %@", fromPath, toPath);
            [fileManager copyItemAtPath:fromPath
                                 toPath:toPath
                                  error: &error];
            if (error) {
                NSLog(@"%@", [error localizedDescription]);
            }
        }
        
    }];
    // Replace those files with updates from some server later as you like by downloading updated versions.

    //    self.viewController = [[ViewController alloc] initWithNibName:nil bundle:nil];
    NSBundle *bundle = [NSBundle bundleWithPath:documentsDirectory];
    self.viewController = [[ViewController alloc] initWithNibName:nil bundle:bundle];



    self.window.rootViewController = self.viewController;
    [self.window makeKeyAndVisible];
    return YES;
}

@end
